/*
Wakanda Software (the "Software") and the corresponding source code remain
the exclusive property of 4D and/or its licensors and are protected by national
and/or international legislations.
This file is part of the source code of the Software provided under the relevant
Wakanda License Agreement available on http://www.wakanda.org/license whose compliance
constitutes a prerequisite to any use of this file and more generally of the
Software and the corresponding source code.
*/


function callAndCheck(func, groupExecID, groupPromoteID) {

    var keepGroupExecID = groupExecID;
    var keepGroupPromoteID = groupPromoteID;
    var keepFunc = func;

    var embbedder = function() {

        var result = null;
        var promotionToken = null;
        var okExec = true;
        var session = ds.currentSession()

        if (groupPromoteID != null && session != null)
            promotionToken = session.promoteWith(groupPromoteID);

        if (groupExecID != null) {
            if (session == null)
                okExec = false;
            else {
                okExec = session.checkPermission(groupExecID);
            }
        }

        if (okExec)
            result = keepFunc.apply(this, arguments);

        if (groupPromoteID != null && promotionToken != null && session != null)
            session.unPromote(promotionToken);

        return result;
    }

    return embbedder;
}

callAndCheck;